package gov.va.med.mhv.admin.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.admin.dto.UserCalCatDTO;
import gov.va.med.mhv.admin.model.UserCalCat;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class UserCalCatConverter implements Converter<UserCalCat, UserCalCatDTO> {

	@Override
	public UserCalCatDTO convert(UserCalCat source) {
		UserCalCatDTO target = new UserCalCatDTO();

		target.setUserCatId(source.getUserCatId());

		if (null != source.getCalendarCategory()) {
			target.setCalendarCategory(new CalendarCategoryConverter().convert(source.getCalendarCategory()));
		}

		if (null != source.getUserCalView()) {
			target.setUserCalView(new UserCalViewConverter().convert(source.getUserCalView()));
		}

		return target;
	}

	public UserCalCat convert(UserCalCatDTO source) {
		UserCalCat target = new UserCalCat();

		target.setUserCatId(source.getUserCatId());

		if (null != source.getCalendarCategory()) {
			target.setCalendarCategory(new CalendarCategoryConverter().convert(source.getCalendarCategory()));
		}

		if (null != source.getUserCalView()) {
			target.setUserCalView(new UserCalViewConverter().convert(source.getUserCalView()));
		}

		return target;
	}

	public List<UserCalCatDTO> convert(List<UserCalCat> source) {
		List<UserCalCatDTO> userCalCatDto = null;

		if (null != source) {
			userCalCatDto = new ArrayList<UserCalCatDTO>();

			for (UserCalCat userCalCat : source) {
				userCalCatDto.add(this.convert(userCalCat));
			}
		}

		return userCalCatDto;
	}

}
